<?php
/**
 * @package     NA Core
 * @version     0.1
 * @author      Nanonerubian
 * @link        http://nanonerubian.co
 * @copyright   Copyright (c) 2015 Nanonerubian
 * @license     GPL v2
 */
if (!class_exists('nerubian_Customize')) {
    class nerubian_Customize
    {
        public $customizers = array();

        public $panels = array();

        public function init()
        {
            $this->customizer();
            add_action('customize_controls_enqueue_scripts', array($this, 'nerubian_customizer_script'));
            add_action('customize_register', array($this, 'nerubian_register_theme_customizer'));
            add_action('customize_register', array($this, 'remove_default_customize_section'), 20);
        }

        public static function &getInstance()
        {
            static $instance;
            if (!isset($instance)) {
                $instance = new nerubian_Customize();
            }
            return $instance;
        }

        protected function customizer()
        {
            $this->panels = array(

                'site_panel' => array(
                    'title'             => esc_html__('Style Setting','nerubian'),
                    'description'       => esc_html__('Style Setting >','nerubian'),
                    'priority'          =>  101,
                ),
                'single_panel' => array(
                    'title'             => esc_html__('Blog Single','nerubian'),
                    'description'       => esc_html__('Blog Single >','nerubian'),
                    'priority'          =>  104,
                ),
                'woo_panel' => array(
                    'title'             => esc_html__('WooCommerce','nerubian'),
                    'description'       => esc_html__('WooCommerce >','nerubian'),
                    'priority'          =>  102,
                ),
                'sidebar_panel' => array(
                    'title'             => esc_html__('Sidebar','nerubian'),
                    'description'       => esc_html__('Sidebar Setting','nerubian'),
                    'priority'          => 105,
                ),
                'nerubian_option_panel' => array(
                    'title'             => esc_html__('Option','nerubian'),
                    'description'       => '',
                    'priority'          => 106,
                ),

            );

            $this->customizers = array(
                'title_tagline' => array(
                    'title' => esc_html__('Site Identity', 'nerubian'),
                    'priority'  =>  1,
                    'settings' => array(
                        'nerubian_logo' => array(
                            'class' => 'image',
                            'label' => esc_html__('Logo', 'nerubian'),
                            'description' => esc_html__('Upload Logo Image', 'nerubian'),
                            'priority' => 12
                        ),
                    )
                ),
//2.General ============================================================================================================
                'nerubian_general' => array(
                    'title' => esc_html__('General', 'nerubian'),
                    'description' => '',
                    'priority' => 2,
                    'settings' => array(

                        'nerubian_bg_body' => array(
                            'label'         => esc_html__('Background - Body', 'nerubian'),
                            'description'   => '',
                            'class'         => 'color',
                            'priority'      => 2,
                            'params'        => array(
                                'default'   => '',
                            ),
                        ),
                        'nerubian_primary_body' => array(
                            'label'         => esc_html__('Primary - Color', 'nerubian'),
                            'description'   => '',
                            'class'         => 'color',
                            'priority'      => 1,
                            'params'        => array(
                                'default'   => '',
                            ),
                        ),
                    )
                ),
//3.Header =============================================================================================================
                'nerubian_header' => array(
                    'title' => esc_html__('Header', 'nerubian'),
                    'description' => '',
                    'priority' => 3,
                    'settings' => array(
                        //header nerubian_topbar

                        'nerubian_topbar' => array(
                            'class' => 'toggle',
                            'label' => esc_html__('Topbar','nerubian'),
                            'priority' => 0,
                            'params' => array(
                                'default' => false,
                            ),
                        ),

                        'nerubian_topbar_info' => array(
                            'class' => 'info',
                            'label' => esc_html__('Info', 'nerubian'),
                            'description' => esc_html__( 'Please goto Appearance > Widgets > drop drag widget to the sidebar Topbar Left and the sidebar Topbar Right.', 'nerubian' ),
                            'priority' => 1,
                        ),

                        'nerubian_header_heading' => array(
                            'class' => 'heading',
                            'label' => esc_html__('Header', 'nerubian'),
                            'priority' => 2,
                        ),

                        'nerubian_header' => array(
                            'class'=> 'layout',
                            'label' => esc_html__('Header Layout', 'nerubian'),
                            'priority' =>3,
                            'choices' => array(
                                'simple'                   => get_template_directory_uri().'/assets/images/header/default.png',
                                'center'                   => get_template_directory_uri().'/assets/images/header/center.png',
                                'left'                     => get_template_directory_uri().'/assets/images/header/left.png',
                                'full'                     => get_template_directory_uri().'/assets/images/header/offcanvas.png',
                            ),
                            'params' => array(
                                'default' => 'left',
                            ),
                        ),
                        'nerubian_header_style' => array(
                            'type' => 'select',
                            'label' => esc_html__('Choose Header Style', 'nerubian'),
                            'description' => '',
                            'priority' => 4,
                            'choices' => array(
                                'style_black'     => esc_html__('Header Black', 'nerubian'),
                                'style_white'     => esc_html__('Header White', 'nerubian')
                            ),
                            'params' => array(
                                'default' => 'style_black',
                            ),
                        ),
                        'nerubian_header_image' => array(
                            'class' => 'image',
                            'label' => esc_html__('Header Background', 'nerubian'),
                            'description' => esc_html__('Upload Background Image', 'nerubian'),
                            'priority' => 5
                        ),
                        'nerubian_keep_menu' => array(
                            'class' => 'toggle',
                            'label' => esc_html__('Keep Menu','nerubian'),
                            'priority' => 6,
                            'params' => array(
                                'default' => false,
                            ),
                        ),
                        'nerubian_bg_header' => array(
                            'label'         => esc_html__('Background - Header', 'nerubian'),
                            'description'   => '',
                            'class'         => 'color',
                            'priority'      => 7,
                            'params'        => array(
                                'default'   => '',
                            ),
                        ),

                        'nerubian_color_menu' => array(
                            'label'         => esc_html__('Color - Text', 'nerubian'),
                            'description'   => '',
                            'class'         => 'color',
                            'priority'      => 8,
                            'params'        => array(
                                'default'   => '',
                            ),
                        ),
                    )
                ),
//4.Footer =============================================================================================================
                'nerubian_new_section_footer' => array(
                    'title' => esc_html__('Footer', 'nerubian'),
                    'description' => '',
                    'priority' => 4,
                    'settings' => array(
                        'nerubian_footer' => array(
                            'type' => 'select',
                            'label' => esc_html__('Choose Footer Style', 'nerubian'),
                            'description' => '',
                            'priority' => -1,
                            'choices' => array(
                                '1'     => esc_html__('Footer 1', 'nerubian'),
                                'hidden' => esc_html__('Hidden Footer', 'nerubian')
                            ),
                            'params' => array(
                                'default' => '1',
                            ),
                        ),


                        'nerubian_enable_footer' => array(
                            'type' => 'checkbox',
                            'label' => esc_html__('Enable Footer', 'nerubian'),
                            'description' => '',
                            'priority' => 0,
                            'params' => array(
                                'default' => '1',
                            ),
                        ),
                        'nerubian_enable_copyright' => array(
                            'type' => 'checkbox',
                            'label' => esc_html__('Enable Copyright', 'nerubian'),
                            'description' => '',
                            'priority' => 0,
                            'params' => array(
                                'default' => '1',
                            ),
                        ),
                        'nerubian_copyright_text' => array(
                            'type' => 'textarea',
                            'label' => esc_html__('Footer Copyright Text', 'nerubian'),
                            'description' => '',
                            'priority' => 0,
                        ),

                        'nerubian_bg_footer' => array(
                            'label'         => esc_html__('Background - Footer', 'nerubian'),
                            'description'   => '',
                            'class'         => 'color',
                            'priority'      => 5,
                            'params'        => array(
                                'default'   => '',
                            ),

                        ),
                        'nerubian_color_footer' => array(
                            'label'         => esc_html__('Color - Text ', 'nerubian'),
                            'description'   => '',
                            'class'         => 'color',
                            'priority'      => 6,
                            'params'        => array(
                                'default'   => '',
                            ),

                        ),
                    )
                ),

//5.Categories Blog ====================================================================================================
                'nerubian_blog' => array(
                    'title' => esc_html__('Blogs Categories', 'nerubian'),
                    'description' => '',
                    'priority' => 103,
                    'settings' => array(

                        'nerubian_sidebar_cat' => array(
                            'class'         => 'layout',
                            'label'         => esc_html__('Sidebar Layout', 'nerubian'),
                            'priority'      =>3,
                            'choices'       => array(
                                'left'         => get_template_directory_uri().'/assets/images/left.png',
                                'right'        => get_template_directory_uri().'/assets/images/right.png',
                                'full'         => get_template_directory_uri().'/assets/images/full.png',
                            ),
                            'params' => array(
                                'default' => 'right',
                            ),
                        ),
                        'nerubian_siderbar_cat_info' => array(
                            'class' => 'info',
                            'label' => esc_html__('Info', 'nerubian'),
                            'description' => esc_html__( 'Please goto Appearance > Widgets > drop drag widget to the sidebar Article.', 'nerubian' ),
                            'priority' => 4,
                        ),
                        //post-layout-cat
                        'nerubian_title_cat_heading' => array(
                            'class' => 'heading',
                            'label' => esc_html__('Post Title Category', 'nerubian'),
                            'priority' =>5,
                        ),
                        'nerubian_post_title_heading' => array(
                            'class' => 'toggle',
                            'label' => esc_html__('Title Category ','nerubian'),
                            'priority' => 6,
                            'params' => array(
                                'default' => true,
                            ),
                        ),

                        'nerubian_post_cat_layout' => array(
                            'class' => 'heading',
                            'label' => esc_html__('Category layout', 'nerubian'),
                            'priority' =>8,
                        ),
                        'nerubian_layout_cat_content' => array(
                            'class'         => 'layout',
                            'priority'      =>9,
                            'choices'       => array(
//                                'tran'        => get_template_directory_uri().'/assets/images/box-tran.jpg',
                                'grid'        => get_template_directory_uri().'/assets/images/box-grid.jpg',
                                'list'        => get_template_directory_uri().'/assets/images/box-list.jpg',
                            ),
                            'params' => array(
                                'default' => 'list',
                            ),
                        ),
                        'nerubian_number_post_cat' => array(
                            'class' => 'slider',
                            'label' => esc_html__('Number post on a row', 'nerubian'),
                            'description' => '',
                            'priority' =>10,
                            'choices' => array(
                                'max' => 4,
                                'min' => 1,
                                'step' => 1
                            ),
                            'params'      => array(
                                'default' =>2
                            ),
                        ),
                        //post article content
                        'nerubian_post_cat_article' => array(
                            'class' => 'heading',
                            'label' => esc_html__('Post content', 'nerubian'),
                            'priority' =>11,
                        ),
                        'nerubian_post_entry_content' => array(
                            'class' => 'toggle',
                            'label' => esc_html__('Content ','nerubian'),
                            'priority' => 12,
                            'params' => array(
                                'default' => true,
                            ),
                        ),
                        'nerubian_number_content_post' => array(
                            'class' => 'slider',
                            'label' => esc_html__('Number of words in the description content', 'nerubian'),
                            'description' => '',
                            'priority' =>13,
                            'choices' => array(
                                'max' => 50,
                                'min' => 20,
                                'step' => 5
                            ),
                            'params'      => array(
                                'default' =>25
                            ),
                        ),

                        //post meta
                        'nerubian_cat_meta' => array(
                            'class' => 'heading',
                            'label' => esc_html__('Post meta', 'nerubian'),
                            'priority' =>13,
                        ),
                        'nerubian_post_meta_share' => array(
                            'class' => 'toggle',
                            'label' => esc_html__('Share ','nerubian'),
                            'priority' => 14,
                            'params' => array(
                                'default' => false,
                            ),
                        ),
                        'nerubian_post_meta_author' => array(
                            'class' => 'toggle',
                            'label' => esc_html__('Author ','nerubian'),
                            'priority' => 15,
                            'params' => array(
                                'default' => true,
                            ),
                        ),
                        'nerubian_post_meta_date' => array(
                            'class' => 'toggle',
                            'label' => esc_html__('Date ','nerubian'),
                            'priority' => 16,
                            'params' => array(
                                'default' => true,
                            ),
                        ),
                        'nerubian_post_meta_comment' => array(
                            'class' => 'toggle',
                            'label' => esc_html__('Comment ','nerubian'),
                            'priority' => 17,
                            'params' => array(
                                'default' => false,
                            ),
                        ),
                        'nerubian_post_meta_view' => array(
                            'class' => 'toggle',
                            'label' => esc_html__('View ','nerubian'),
                            'priority' => 18,
                            'params' => array(
                                'default' => false,
                            ),
                        ),
                    ),
                ),
//6.Single blog ========================================================================================================
                'nerubian_single_sidebar' => array(
                    'title' => esc_html__('Sidebar Layout', 'nerubian'),
                    'description' => '',
                    'panel' =>'single_panel',
                    'priority' => 6,
                    'settings' => array(
                        'nerubian_sidebar_single' => array(
                            'class'         => 'layout',
                            'label'         => esc_html__('Sidebar Layout', 'nerubian'),
                            'priority'      =>1,
                            'choices'       => array(
//                                'left'         => get_template_directory_uri().'/assets/images/left.png',
                                'right'        => get_template_directory_uri().'/assets/images/right.png',
                                'full'         => get_template_directory_uri().'/assets/images/full.png',
                            ),
                            'params' => array(
                                'default' => 'right',
                            ),
                        ),
                        'nerubian_siderbar_single_info' => array(
                            'class' => 'info',
                            'label' => esc_html__('Info', 'nerubian'),
                            'description' => esc_html__( 'Please goto Appearance > Widgets > drop drag widget to the sidebar Blog .', 'nerubian' ),
                            'priority' => 2,
                        ),

                        'nerubian_single_own' => array(
                            'class' => 'toggle',
                            'label' => esc_html__('Use Single sidebar','nerubian'),
                            'priority' => 3,
                            'params' => array(
                                'default' => false,
                            ),
                        ),
                        'nerubian_siderbar_single2_info' => array(
                            'class' => 'info',
                            'label' => esc_html__('Info', 'nerubian'),
                            'description' => esc_html__( 'When you active use Single sidebar , Please goto Appearance > Widgets > drop drag widget to the sidebar Single  not sidebar Blog.', 'nerubian' ),
                            'priority' => 4,
                        ),
                    ),
                ),
                //Share
                'nerubian_single_layout' => array(
                    'title' => esc_html__('Social Share', 'nerubian'),
                    'description' => '',
                    'panel' =>'single_panel',
                    'priority' => 6,
                    'settings' => array(
                        //share
                        'nerubian_share_position' => array(
                            'type' => 'select',
                            'label' => esc_html__('Position Share', 'nerubian'),
                            'description' => '',
                            'priority' => 10,
                            'choices' => array(
                                'fixed' => 'Fixed left',
                                'bottom' => 'Bottom of the article',
                            ),
                            'params' => array(
                                'default' => 'fixed',
                            ),

                        ),
                        'nerubian_share_heading' => array(
                            'class' => 'heading',
                            'label' => esc_html__('Options', 'nerubian'),
                            'priority' =>18,
                        ),
                        'nerubian_share_facebook' => array(
                            'class' => 'toggle',
                            'label' => esc_html__('Share Facebook  ','nerubian'),
                            'priority' => 21,
                            'params' => array(
                                'default' => false,
                            ),
                        ),
                        'nerubian_share_twitter' => array(
                            'class' => 'toggle',
                            'label' => esc_html__('Share Twitter  ','nerubian'),
                            'priority' => 22,
                            'params' => array(
                                'default' => false,
                            ),
                        ),
                        'nerubian_share_google' => array(
                            'class' => 'toggle',
                            'label' => esc_html__('Share Google  ','nerubian'),
                            'priority' => 23,
                            'params' => array(
                                'default' => false,
                            ),
                        ),
                        'nerubian_share_linkedin' => array(
                            'class' => 'toggle',
                            'label' => esc_html__('Share Linkedin  ','nerubian'),
                            'priority' => 24,
                            'params' => array(
                                'default' => false,
                            ),
                        ),
                        'nerubian_share_pinterest' => array(
                            'class' => 'toggle',
                            'label' => esc_html__('Share Pinterest  ','nerubian'),
                            'priority' => 25,
                            'params' => array(
                                'default' => false,
                            ),
                        ),
                        'nerubian_share_whatsapp' => array(
                            'class' => 'toggle',
                            'label' => esc_html__('Share Whatsapp  ','nerubian'),
                            'priority' => 36,
                            'params' => array(
                                'default' => false,
                            ),
                        ),
                    ),
                ),
                //Comments
                'nerubian_single_comments' => array(
                    'title' => esc_html__('Comments', 'nerubian'),
                    'description' => '',
                    'panel' =>'single_panel',
                    'priority' => 6,
                    'settings' => array(
                        //comments
                        'nerubian_comments' => array(
                            'class' => 'toggle',
                            'label' => esc_html__('Comments Box', 'nerubian'),
                            'priority' =>16,
                            'params' => array(
                                'default' => true,
                            ),
                        ),
                        'nerubian_comments_heading' => array(
                            'class' => 'heading',
                            'label' => esc_html__('Options', 'nerubian'),
                            'priority' =>18,
                        ),
                        'nerubian_comments_single_facebook' => array(
                            'class' => 'toggle',
                            'label' => esc_html__('Enable Facebook Comments ','nerubian'),
                            'priority' => 29,
                            'params' => array(
                                'default' => false,
                            ),
                        ),

                        'nerubian_comments_single' => array(
                            'type'          => 'text',
                            'label'         => esc_html__('Your app id :', 'nerubian'),
                            'priority'      => 30,
                            'params'        => array(
                                'default'   => '',
                            ),
                        ),
                        'nerubian_comments_single_info' => array(
                            'class' => 'info',
                            'label' => esc_html__('Info', 'nerubian'),
                            'description' => esc_html__('If you want show notification on  your facebook , please input app id ...', 'nerubian' ),
                            'priority' => 31,
                        ),
                    ),
                ),

                'nerubian_single_meta' => array(
                    'title' => esc_html__('Meta', 'nerubian'),
                    'description' => '',
                    'panel' =>'single_panel',
                    'priority' => 6,
                    'settings' => array(
                        //avatar-meta
                        'nerubian_avatar_meta' => array(
                            'class' => 'toggle',
                            'label' => esc_html__('Author', 'nerubian'),
                            'priority' =>1,
                            'params' => array(
                                'default' => true,
                            ),
                        ),
                        'nerubian_avatar_meta_info' => array(
                            'class' => 'info',
                            'label' => esc_html__('Info', 'nerubian'),
                            'description' => esc_html__( 'Show or Hidden  Author under the Title Post.If you want to disable/enable Author Box under Post , Please put or delete description in the User > Your profile > Biographical Info ', 'nerubian' ),
                            'priority' => 2,
                        ),
                        //avatar-meta
                        'nerubian_image_meta' => array(
                            'class' => 'toggle',
                            'label' => esc_html__('Featured Image', 'nerubian'),
                            'priority' =>3,
                            'params' => array(
                                'default' => true,
                            ),
                        ),
                    ),
                ),
                'nerubian_single_related' => array(
                    'title' => esc_html__('Related Box', 'nerubian'),
                    'description' => '',
                    'panel' =>'single_panel',
                    'priority' => 6,
                    'settings' => array(
                        //related_posts
                        'nerubian_related' => array(
                            'class' => 'toggle',
                            'label' => esc_html__('Related Posts', 'nerubian'),
                            'priority' =>17,
                            'params' => array(
                                'default' => true,
                            ),
                        ),
                        'nerubian_related_heading' => array(
                            'class' => 'heading',
                            'label' => esc_html__('Options', 'nerubian'),
                            'priority' =>18,
                        ),
                        'nerubian_related_number' => array(
                            'type' => 'select',
                            'label' => esc_html__('Number Post Show', 'nerubian'),
                            'description' => '',
                            'priority' => 25,
                            'choices' => array(
                                '2' => '2',
                                '3' => '3',
                                '4' => '4',
                                '5' => '4',
                                '6' => '6',
                                '8' => '8',
                            ),
                            'params' => array(
                                'default' => '3',
                            ),

                        ),
                        'nerubian_related_rows' => array(
                            'type' => 'select',
                            'label' => esc_html__('Number Rows', 'nerubian'),
                            'description' => '',
                            'priority' => 25,
                            'choices' => array(
                                '2' => '2',
                                '3' => '3',
                                '4' => '4',
                                '6' => '6',
                            ),
                            'params' => array(
                                'default' => '3',
                            ),

                        ),
                    ),
                ),
                'nerubian_single_videos' => array(
                    'title' => esc_html__('Videos Box', 'nerubian'),
                    'description' => '',
                    'panel' =>'single_panel',
                    'priority' => 6,
                    'settings' => array(
                        //Videos
                        'nerubian_videos_box' => array(
                            'class' => 'toggle',
                            'label' => esc_html__('Videos Box', 'nerubian'),
                            'priority' =>1,
                            'params' => array(
                                'default' => true,
                            ),
                        ),
                        'nerubian_videos_heading' => array(
                            'class' => 'heading',
                            'label' => esc_html__('Options', 'nerubian'),
                            'priority' =>2,
                        ),
                        'nerubian_videos_cat' => array(
                            'class'          => 'multiple',
                            'label'         => esc_html__('Categories', 'nerubian'),
                            'choices'       => nerubian_get_categories_select(),
                            'priority'      => 3,
                            'params'        => array(
                                'default'       => esc_html__('', 'nerubian'),
                            ),

                        ),
                        'nerubian_videos_show' => array(
                            'class' => 'slider',
                            'label' => esc_html__('Number of videos displayed on a Slider', 'nerubian'),
                            'description' => '',
                            'priority' =>5,
                            'choices' => array(
                                'max' => 6,
                                'min' => 2,
                                'step' => 1
                            ),
                            'params'      => array(
                                'default' =>2
                            ),
                        ),
                        'nerubian_videos_number' => array(
                            'class' => 'slider',
                            'label' => esc_html__('Number of videos', 'nerubian'),
                            'description' => '',
                            'priority' =>6,
                            'choices' => array(
                                'max' => 50,
                                'min' => 3,
                                'step' => 1
                            ),
                            'params'      => array(
                                'default' =>4
                            ),
                        ),
                    ),
                ),
                'nerubian_single_readmore' => array(
                    'title' => esc_html__('Read More Box', 'nerubian'),
                    'description' => '',
                    'panel' =>'single_panel',
                    'priority' => 6,
                    'settings' => array(
                        //Read More
                        'nerubian_readmore_box' => array(
                            'class' => 'toggle',
                            'label' => esc_html__('Read More Box', 'nerubian'),
                            'priority' =>1,
                            'params' => array(
                                'default' => false,
                            ),
                        ),
                        'nerubian_readmore_heading' => array(
                            'class' => 'heading',
                            'label' => esc_html__('Options', 'nerubian'),
                            'priority' =>2,
                        ),
                        'nerubian_readmore_cat' => array(
                            'class'          => 'multiple',
                            'label'         => esc_html__('Categories', 'nerubian'),
                            'choices'       => nerubian_get_categories_select(),
                            'priority'      => 3,
                            'params'        => array(
                                'default'       => esc_html__('', 'nerubian'),
                            ),

                        ),
                        'nerubian_readmore_layout' => array(
                            'class'         => 'layout',
                            'priority'      =>4,
                            'label'         => esc_html__('Layouts', 'nerubian'),
                            'choices'       => array(
                                'grid'        => get_template_directory_uri().'/assets/images/box-grid.jpg',
                                'list'        => get_template_directory_uri().'/assets/images/box-list.jpg',
                            ),
                            'params' => array(
                                'default' => 'list',
                            ),
                        ),
                        'nerubian_readmore_show' => array(
                            'class' => 'slider',
                            'label' => esc_html__('Number of posts displayed on a page', 'nerubian'),
                            'description' => '',
                            'priority' =>5,
                            'choices' => array(
                                'max' => 10,
                                'min' => 2,
                                'step' => 1
                            ),
                            'params'      => array(
                                'default' =>6
                            ),
                        ),
                        'nerubian_readmore_content' => array(
                            'class' => 'toggle',
                            'label' => esc_html__('Content Article', 'nerubian'),
                            'class' => 'toggle',
                            'priority' =>6,
                            'params' => array(
                                'default' => false,
                            ),
                        ),
                        'nerubian_readmore_view_cats' => array(
                            'class' => 'toggle',
                            'label' => esc_html__('Category', 'nerubian'),
                            'class' => 'toggle',
                            'priority' =>7,
                            'params' => array(
                                'default' => true,
                            ),
                        ),
                        'nerubian_readmore_meta' => array(
                            'class' => 'toggle',
                            'label' => esc_html__('Meta Article', 'nerubian'),
                            'priority' =>8,
                            'params' => array(
                                'default' => false,
                            ),
                        ),
                        'nerubian_readmore_btn' => array(
                            'class' => 'toggle',
                            'label' => esc_html__('Load More Button', 'nerubian'),
                            'priority' =>9,
                            'params' => array(
                                'default' => true,
                            ),
                        ),

                    ),
                ),
//7.Adsense blog ========================================================================================================
                'nerubian_ads' => array(
                    'title' => esc_html__('Adsense Setting', 'nerubian'),
                    'description' => '',
                    'panel' =>'single_panel',
                    'priority' => 7,
                    'settings' => array(

                        'nerubian_ads_rectangle' => array(
                            'type' => 'textarea',
                            'label' => esc_html__(' ADS Size: Large Rectangle', 'nerubian'),
                            'description' => '',
                            'priority' => 1,
                        ),
                        'nerubian_ads_rectangle_info' => array(
                            'class' => 'info',
                            'label' => esc_html__('Info', 'nerubian'),
                            'description' => esc_html__('Add code ads by google with the size is:300x250', 'nerubian' ),
                            'priority' => 2,
                        ),
                        'nerubian_ads_leaderboard' => array(
                            'type' => 'textarea',
                            'label' => esc_html__('ADS Size: Leaderboard', 'nerubian'),
                            'description' => 'Add code ads by google with the size is: 468x60 ,728x90, 920x180 ...',
                            'priority' => 3,
                        ),
                        'nerubian_ads_vertical' => array(
                            'type' => 'textarea',
                            'label' => esc_html__('ADS Size: Rectangle Vertical', 'nerubian'),
                            'description' => 'Add code ads by google with the size is: 160x600',
                            'priority' => 4,
                        ),
                        'nerubian_ads_bottom' => array(
                            'type' => 'textarea',
                            'label' => esc_html__('ADS Size:Billboard', 'nerubian'),
                            'description' => 'You can place any size ad in this responsive area.',
                            'priority' => 5,
                        ),
                        'nerubian_heading_ads_single' => array(
                            'class' => 'heading',
                            'label' => esc_html__('Position AD', 'nerubian'),
                            'priority' =>20,
                        ),
                        'nerubian_ads_single_article' => array(
                            'class' => 'toggle',
                            'label' => esc_html__('Ad right of the post','nerubian'),
                            'priority' => 21,
                            'params' => array(
                                'default' => false,
                            ),
                        ),
                        'nerubian_ads_single_left' => array(
                            'class' => 'toggle',
                            'label' => esc_html__('Ad left of the post','nerubian'),
                            'priority' => 22,
                            'params' => array(
                                'default' => false,
                            ),
                        ),
                        'nerubian_ads_single_comment' => array(
                            'class' => 'toggle',
                            'label' => esc_html__('Ad located between the boxes','nerubian'),
                            'priority' => 23,
                            'params' => array(
                                'default' => false,
                            ),
                        ),
                        'nerubian_ads_single_bottom' => array(
                            'class' => 'toggle',
                            'label' => esc_html__('Ad Under the bottom of the post','nerubian'),
                            'priority' => 24,
                            'params' => array(
                                'default' => false,
                            ),
                        ),
                    )
                ),
//8.Woocommerces  Category =============================================================================================
                'nerubian_woo_cat' => array(
                    'title' => esc_html__('Categories', 'nerubian'),
                    'description' => '',
                    'panel' =>'woo_panel',
                    'priority' => 8,
                    'settings' => array(
                        //siderbar
                        'nerubian_sidebar_woo' => array(
                            'class'=> 'layout',
                            'label' => esc_html__('Sidebar', 'nerubian'),
                            'priority' =>2,
                            'choices' => array(
                                'left'         => get_template_directory_uri().'/assets/images/left.png',
                                'full'         => get_template_directory_uri().'/assets/images/full.png',
                                'right'         => get_template_directory_uri().'/assets/images/right.png',
                            ),
                            'params' => array(
                                'default' => 'left',
                            ),
                        ),
                        'nerubian_siderbar_info' => array(
                            'class' => 'info',
                            'label' => esc_html__('Info', 'nerubian'),
                            'description' => esc_html__( 'Please goto Appearance > Widgets > drop drag widget to the sidebar SHOP.', 'nerubian' ),
                            'priority' => 3,
                        ),
                        //category
                        'nerubian_header_woocat' => array(
                            'class' => 'heading',
                            'label' => esc_html__('Categories Product', 'nerubian'),
                            'priority' =>1,
                        ),
                        'nerubian_woo_cat_breadcrumb_image' => array(
                            'class'          => 'image',
                            'label'         => esc_html__('Breadcrumb image Title', 'nerubian'),
                            'priority'      => 6,
                            'params'        => array(
                                'default'   => '',
                            ),

                        ),
                        'nerubian_woo_number_product' => array(
                            'class' => 'slider',
                            'label' => esc_html__('Number products on a row', 'nerubian'),
                            'description' => '',
                            'priority' =>9,
                            'choices' => array(
                                'max' => 6,
                                'min' => 2,
                                'step' => 1
                            ),
                            'params'      => array(
                                'default' => 3
                            ),
                        ),
                        'nerubian_woo_product_per_page' => array(
                            'class' => 'slider',
                            'label' => esc_html__('Number products per page', 'nerubian'),
                            'description' => '',
                            'priority' =>9,
                            'choices' => array(
                                'max' => 36,
                                'min' => 6,
                                'step' => 1
                            ),
                            'params'      => array(
                                'default' => 9
                            ),
                        ),

                    ),
                ),

//9.Woocommerces Detail  ===============================================================================================
                'nerubian_woo_detail' => array(
                    'title' => esc_html__('Product Detail', 'nerubian'),
                    'description' => '',
                    'panel' =>'woo_panel',
                    'priority' => 9,
                    'settings' => array(
                        //siderbar
                        'nerubian_sidebar_woo_single' => array(
                            'class'=> 'layout',
                            'label' => esc_html__('Sidebar', 'nerubian'),
                            'priority' =>2,
                            'choices' => array(
                                'left'         => get_template_directory_uri().'/assets/images/left.png',
                                'full'         => get_template_directory_uri().'/assets/images/full.png',
                                'right'         => get_template_directory_uri().'/assets/images/right.png',
                            ),
                            'params' => array(
                                'default' => 'full',
                            ),
                        ),
                        'nerubian_woo_related_products' => array(
                            'type'          => 'checkbox',
                            'label'         => esc_html__('Display Related Products', 'nerubian'),
                            'priority'      => 24,
                            'params'        => array(
                                'default'   => true,
                            ),

                        ),
                        'nerubian_woo_number_related_products' => array(
                            'type' => 'select',
                            'label' => esc_html__('Number Products Show', 'nerubian'),
                            'description' => '',
                            'priority' => 25,
                            'choices' => array(
                                '2' => '2',
                                '3' => '3',
                                '4' => '4',
                                '5' => '5'
                            ),
                            'params' => array(
                                'default' => '4',
                            ),

                        ),
                        //Share products
                        'nerubian_cat_content_heading' => array(
                            'class' => 'heading',
                            'label' => esc_html__('Share', 'nerubian'),
                            'priority' =>25,
                        ),
                        'nerubian_woo_share_facebook' => array(
                            'class' => 'toggle',
                            'label' => esc_html__('Facebook','nerubian'),
                            'priority' => 26,
                            'params' => array(
                                'default' => false,
                            ),

                        ),
                        'nerubian_woo_share_twitter' => array(
                            'class' => 'toggle',
                            'label' => esc_html__('Twitter','nerubian'),
                            'priority' => 27,
                            'params' => array(
                                'default' => false,
                            ),

                        ),
                        'nerubian_woo_share_pinterest' => array(
                            'class' => 'toggle',
                            'label' => esc_html__('Pinterest','nerubian'),
                            'priority' => 28,
                            'params' => array(
                                'default' => false,
                            ),

                        ),
                        'nerubian_woo_share_google' => array(
                            'class' => 'toggle',
                            'label' => esc_html__('Google +','nerubian'),
                            'priority' => 29,
                            'params' => array(
                                'default' => false,
                            ),

                        ),
                        'nerubian_woo_share_linkedin' => array(
                            'class' => 'toggle',
                            'label' => esc_html__('linkedin','nerubian'),
                            'priority' => 30,
                            'params' => array(
                                'default' => false,
                            ),

                        ),

                    ),
                ),
//Font   ===============================================================================================================
                'nerubian_new_section_font_size' => array(
                    'title' => esc_html__('Font', 'nerubian'),
                    'priority' => 8,
                    'settings' => array(
                        'nerubian_body_font_google' => array(
                            'type'          => 'select',
                            'label'         => esc_html__('Body Font', 'nerubian'),
                            'choices'       => nerubian_googlefont(),
                            'priority'      => 0,
                            'params'        => array(
                                'default'       => 'Roboto',
                            ),

                        ),
                        'nerubian_body_font_size' => array(
                            'class' => 'slider',
                            'label' => esc_html__('Font size Body ', 'nerubian'),
                            'description' => '',
                            'priority' =>8,
                            'choices' => array(
                                'max' => 30,
                                'min' => 10,
                                'step' => 1
                            ),
                            'params'      => array(
                                'default' => 16,
                            ),
                        ),

                        'nerubian_title_font_google' => array(
                            'type'          => 'select',
                            'label'         => esc_html__('Title Font', 'nerubian'),
                            'choices'       => nerubian_googlefont(),
                            'priority'      => 9,
                            'params'        => array(
                                'default'       => 'Oswald',
                            ),

                        ),
                        'nerubian_menu_font_google' => array(
                            'type'          => 'select',
                            'label'         => esc_html__('Menu Font', 'nerubian'),
                            'choices'       => nerubian_googlefont(),
                            'priority'      => 10,
                            'params'        => array(
                                'default'       => 'Oswald',
                            ),

                        ),

                    )
                ),
//Style  ===============================================================================================================


            );
        }

        public function nerubian_customizer_script()
        {
            // Register
            wp_enqueue_style('na-customize', get_template_directory_uri() . '/inc/customize/assets/css/customizer.css', array(),null);
            wp_enqueue_style('jquery-ui', get_template_directory_uri() . '/inc/customize/assets/css/jquery-ui.min.css', array(),null);
            wp_enqueue_script('na-customize', get_template_directory_uri() . '/inc/customize/assets/js/customizer.js', array('jquery'), null, true);
        }

        public function add_customize($customizers) {
            $this->customizers = array_merge($this->customizers, $customizers);
        }


        public function nerubian_register_theme_customizer()
        {
            global $wp_customize;

            foreach ($this->customizers as $section => $section_params) {

                //add section
                $wp_customize->add_section($section, $section_params);
                if (isset($section_params['settings']) && count($section_params['settings']) > 0) {
                    foreach ($section_params['settings'] as $setting => $params) {

                        //add setting
                        $setting_params = array();
                        if (isset($params['params'])) {
                            $setting_params = $params['params'];
                            unset($params['params']);
                        }
                        $wp_customize->add_setting($setting, array_merge( array( 'sanitize_callback' => null ), $setting_params));
                        //Get class control
                        $class = 'WP_Customize_Control';
                        if (isset($params['class']) && !empty($params['class'])) {
                            $class = 'WP_Customize_' . ucfirst($params['class']) . '_Control';
                            unset($params['class']);
                        }

                        //add params section and settings
                        $params['section'] = $section;
                        $params['settings'] = $setting;

                        //add controll
                        $wp_customize->add_control(
                            new $class($wp_customize, $setting, $params)
                        );
                    }
                }
            }

            foreach($this->panels as $key => $panel){
                $wp_customize->add_panel($key, $panel);
            }

            return;
        }

        public function remove_default_customize_section()
        {
            global $wp_customize;
//            // Remove Sections
//            $wp_customize->remove_section('title_tagline');
            $wp_customize->remove_section('header_image');
            $wp_customize->remove_section('nav');
            $wp_customize->remove_section('static_front_page');
            $wp_customize->remove_section('colors');
            $wp_customize->remove_section('background_image');
        }
    }
}